"fila" <- function(lambda, rho, n, plot = TRUE) {
  if(missing(lambda)){
    cat <- cat("entre com o valor para o parametro de chegada na fila\n")
    lambda <- as.numeric(readline(prompt="lambda = "))
  }
  if(is.na(lambda) | !is.numeric(lambda))
    stop("um valor numerico para \"lambda\" deve ser fornecido")
  ##
  if(missing(rho)){
    cat("entre com o valor do parametro para a taxa de atendimento\n")
    rho <- as.numeric(readline(prompt="rho = "))
  }
  if(is.na(rho) | !is.numeric(rho))
    stop("um valor numerico para \"rho\" deve ser fornecido")
  ##
  if(missing(n)){
    cat("entre com o valor do numero de chegadas\n")
    n <- as.numeric(readline(prompt="n = "))
  }
  if(is.na(n) | (!is.numeric(n) && !is.integer(n)))
    stop("um valor numerico para \"n\" deve ser fornecido")
  ##
  N <- 2*n
  arrivals <- cumsum(rexp(N)/lambda)
  services <- cumsum(rexp(N)/rho)
  labels <- c(rep(1,N),rep(2,N))
  times <- c(arrivals,services)
  lab <- labels[order(times)]
  size <- 0
  fila <- rep(0,1+2*N)
  for (i in 1:(2*N)) {
    if (lab[i]==1) fila[i+1] <- fila[i]+1
    if (lab[i]==2) fila[i+1] <- max(0,fila[i]-1)
  }
  res <- cbind(times = c(0,sort(times)), fila = fila)[1:(1+N),]
  class(res) <- "fila"
  if(plot)
    plot.fila(res)
  return(invisible(res))
#  return(res)
}

"plot.fila" <- function(x, ...) {
  times <- x[,1]; m <- length(times); tt <- matrix(times[2:m],m-1,2)
  tt <- c(times[1],c(t(tt)))
  heights <- x[,2]; hh <- matrix(heights[1:(m-1)],m-1,2)
  hh <- c(c(t(hh)),heights[m])
  plot(tt, hh, type="l", xlab="tempo", ylab="tamanho da fila")
  return(invisible())
}

