\name{hl}
\docType{data}

\alias{hl}

\title{PAD  -  Dados de hormonios luteinizantes em vacas }

\usage{data(hl)}

\description{
O \code{lh} data frame tem 100 linhas e 8 colunas.

Este conjunto de dados registra as concentradoes de hormonios luteinizantes em amostras de sangue retiradas em intervalos de 15 minutos em cada uma das 8 vacas.

As oito colunas correspondem as 8 vacas e as linhas sao os tempos para a sequencia de medicao de cada vaca.
}

\format{
  Este data frame contem as seguintes colunas:
  \describe{
    \item{vaca1,vaca2,vaca3,vaca4,vaca5,vaca6,vaca7,vaca8}{um vetor numerico com as medicoes em \emph{vaca1}
      to \emph{vaca8}.  }
  }
}

%\details{
%}

\source{
Diggle, P.J. and Zeger, S.L. (1984)  A non-Gaussian model for 
time series with pulses. \emph{JASA} 354-9.
}

%\references{
%~~ possibly secondary sources and usages ~~
%}

\examples{
pmf <- par()$mfrow
##
data(hl)
par(mfrow=c(4,2), mar=c(3,3,3,1))
for(i in 1:length(hl))
  plot(hl[,i], type="l", ylim=range(hl), main=paste("vaca", i))
##
par(mfrow=pmf)
}

\keyword{datasets}
