\name{mandibula}
\docType{data}

\alias{mandibula}


\title{PAD  -  Dados de mandibulas do Chacal dourado}

\usage{data(mandibula)}

\description{
  O \code{mandibula} data frame tem 10 linhas e 2 colunas.

  Os dados sao comprimentos da mandibula em mm) para macho e femea do Chacal dourado
(\emph{Canis aureus}) para 10 de cada sexo em uma colecao no Museo Britanico (Historia Natural).
}

\format{
  Este data frame contem as seguintes colunas:
  \describe{
    \item{femea}{um vetor numerico com o comprimento da mandibula das femeas
      \eqn{(mm)}.  }
    \item{macho}{um vetor numerico com o comprimento da mandibula dos machos 
     \eqn{(mm)}.  }
  }
}

%\details{
% ~~ If necessary, more details than the _description_ above ~~
%}

\source{
Higham, C.F, Kijngam, A. and Manly, B.F.J. (1980) An analysis of
prehistoric canid remains from Thailand. Journal of Archeologycal
Science, 7, 149-165.
}

\references{
Manly, B.F.J. (1991) Randomization, Bootstrap and Monte Carlo methods in
Biology. Second Edition. Chapman and Hall.
}

\examples{
data(mandibula)
summary(mandibula)
boxplot(mandibula)
}

\keyword{datasets}
