\name{tcl}

\alias{tcl}
\alias{plot.tcl}
\alias{tcl.plot1}
\alias{tcl.plot2}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{PAD  -  Ilustracoes do Teorema Central do Limite}

\description{
  Escolhe amostras de tamanho \eqn{n} de um vetor de dados de tamanho \eqn{N} e calcula a distribuicao empirica amostral da media, ilustrando assim o Teorema Central do Limite.
}

\usage{
tcl(x, n, nsim, plot = TRUE, ncols = 2)

\method{plot}{tcl}(x, \dots)
}

%- maybe also `usage' for other objects documented here.

\arguments{
  \item{x}{um vetor numerico com os dados}
  \item{n}{um inteiro que define o tamanho da amostra}
  \item{nsim}{um numero inteiro definido de amostras a serem tomadas}
  \item{plot}{logico. Se \code{TRUE} histogramas sao prouzidos em um dispositivo grafico.  }
  \item{ncol}{numerical. O numero de colunas em um dispositivo grafico. Somente valido se \code{plot = TRUE}. }
  \item{\dots}{nao utilizado.} 
}

%%\details{
%  ~~ If necessary, more details than the __description__  above ~~
%}

\value{
  
  Retornar um lista que é um objeto da classe  \code{tcl}. A lista de componentes sao:

  \item{dados}{um vetor com os dados passados para a funcao}
  \item{tamN}{uma lista com vetores de medias (\code{xbar})  e desvios - padrao (\code{dp}) de cada amostra}
  
  Para cada amostra de tamanho \eqn{N} havera uma componente como este ultimo.
  
  \mbox{}
  
  A funcao \code{hist.tcl} plota histogramas das medias amostrais sobre o grafico atual.
  
}

%\references{ ~put references to the literature/web site here ~ }

\author{
  Peter J. Diggle \email{p.diggle@lancaster.ac.uk} \cr
  Paulo Justiniano Ribeiro Jr. \email{p.ribeiro@lancaster.ac.uk}.
}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

%\seealso{ ~~objects to SEE ALSO as \code{\link{~~fun~~}}, ~~~ }

\examples{
tcl(rexp(1000), c(2,4,8,16,32), 1000)
#
par.now <- par(no.readonly=TRUE)
par(mfrow=c(3,2))
data.tcl <- tcl(exp(rnorm(2000)), c(2,4,8,16,32), 1000, plot=FALSE)
plot(data.tcl)
par(par.now)
#
# For an interactive input type:
\dontrun{
tcl()
}
}

\keyword{dplot}

